// By EVOLVED
// www.evolved-software.com

#include "settings.fx"

//--------------
// un-tweaks
//--------------
   float4x4 ViewProj;
   float4x4 View;

//--------------
// tweaks
//--------------  
   float2 ViewSize;
   float2 Aspect={1.0,1.0};
   float Offset=4.0;
   float Density=0.015;
   float Decay=0.95;
   float3 LightDirection;

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
         Texture=<RenderTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };
   texture MaskTexture <string Name = "";>;	
   sampler MaskSampler=sampler_state 
      {
         texture=<MaskTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };

//--------------
// structs 
//--------------
   struct InPut
      {
         float4 Pos:POSITION;
      };
   struct OutPut
      {
         float4 Pos:POSITION; 
         float4 Tex:TEXCOORD0;
         float4 Tex1:TEXCOORD1;
         float4 Tex2:TEXCOORD2;
         float4 Tex3:TEXCOORD3;
         float4 Tex4:TEXCOORD4;
      };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
      {
         OutPut OUT;
         OUT.Pos=IN.Pos; 
         OUT.Tex.xy=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize;
         OUT.Tex.zw=0.0;
         OUT.Tex1.xy=OUT.Tex+float2(ViewSize.x,0)*Offset*Aspect*1.2;
         OUT.Tex1.zw=OUT.Tex+float2(0,ViewSize.y)*Offset*Aspect*1.2;
         OUT.Tex2.xy=OUT.Tex-float2(ViewSize.x,0)*Offset*Aspect*1.2;
         OUT.Tex2.zw=OUT.Tex-float2(0,ViewSize.y)*Offset*Aspect*1.2;
         OUT.Tex3.xy=OUT.Tex+float2(ViewSize.x,ViewSize.y)*Offset*Aspect;
         OUT.Tex3.zw=OUT.Tex-float2(ViewSize.x,ViewSize.y)*Offset*Aspect;
         OUT.Tex4.xy=OUT.Tex+float2(-ViewSize.x,ViewSize.y)*Offset*Aspect;
         OUT.Tex4.zw=OUT.Tex+float2(ViewSize.x,-ViewSize.y)*Offset*Aspect;
         return OUT;
      }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
      {
         float3 FrameRender=tex2Dlod(RenderSampler,IN.Tex).xyz*0.25
                           +tex2Dlod(RenderSampler,IN.Tex1.xyyy).xyz*0.125
                           +tex2Dlod(RenderSampler,IN.Tex1.zwww).xyz*0.125
                           +tex2Dlod(RenderSampler,IN.Tex2.xyyy).xyz*0.125
                           +tex2Dlod(RenderSampler,IN.Tex2.zwww).xyz*0.125
                           +tex2Dlod(RenderSampler,IN.Tex3.xyyy).xyz*0.0625
                           +tex2Dlod(RenderSampler,IN.Tex3.zwww).xyz*0.0625
                           +tex2Dlod(RenderSampler,IN.Tex4.xyyy).xyz*0.0625
                           +tex2Dlod(RenderSampler,IN.Tex4.zwww).xyz*0.0625;
         float Scatter=0;
         #if LightScattering == 1
          float4 ScreenToLight=mul(LightDirection,ViewProj);
          ScreenToLight.xy=float2(ScreenToLight.x*0.5+0.5*ScreenToLight.w,0.5*ScreenToLight.w-ScreenToLight.y*0.5);
          float2 DeltaTex=((ScreenToLight.xy/ScreenToLight.w)-IN.Tex)*sign(ScreenToLight.z)*Density;
          float FallOff=1.0;
          for (int i=0; i < 32; i++) {
           IN.Tex.xy +=DeltaTex;
           Scatter +=(1-tex2Dlod(MaskSampler,IN.Tex).z)*FallOff;
           FallOff *=Decay;
          }
          Scatter *=0.03125;
          Scatter *=saturate(dot(mul(-LightDirection,View),float3(0.0,0.0,-0.5)));
         #endif
         return float4(FrameRender,Scatter);
      }

//--------------
// techniques   
//--------------
   technique Bloom
      {
         pass p1
      {	
         VertexShader = compile vs_3_0 VS();
         PixelShader  = compile ps_3_0 PS();
         zwriteenable=false;
         zenable=false;
         zFunc=always;
      }
      }
